unit ColorIndexSelector;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ColorPalette, Utility, Spin;

type
  TfrmColorIndexSelector = class( TForm )
    Label1: TLabel;
    dfIndex: TPanel;
    pbOK: TButton;
    pbCancel: TButton;
    ColorPalette1: TColorPalette;
    procedure pbPalPaint(Sender: TObject);
    procedure pbPalMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDblClick(Sender: TObject);
  private
    bCreated: boolean;
    function GetPalette: HPalette; override;
  public
    nIndex: integer;
  end;

var
  frmColorIndexSelector: TfrmColorIndexSelector;

implementation

{$R *.DFM}

function TfrmColorIndexSelector.GetPalette: HPalette;
begin
  Result := ColorPalette1.Palette;
end;

procedure TfrmColorIndexSelector.pbPalPaint(Sender: TObject);
var
  x, y: integer;
  rectFill: TRect;
begin
  SelectPalette( Canvas.Handle, ColorPalette1.Palette, FALSE );
  RealizePalette( Canvas.Handle );
  Canvas.Brush.Style := bsSolid;
  for x := 0 to 15 do
    for y := 0 to 15 do
     begin
       Canvas.Brush.Color := PaletteIndex( y * 16 + x );
       rectFill.Left := x * 16 + 8;
       rectFill.Top := y * 16 + 8;
       rectFill.Right := rectFill.Left + 15;
       rectFill.Bottom := rectFill.Top + 15;
       Canvas.FillRect( rectFill );
     end;
  Canvas.Pen.Color := clYellow;
  Canvas.Brush.Style := bsClear;
  x := nIndex mod 16 * 16 + 8;
  y := nIndex div 16 * 16 + 8;
  Canvas.Rectangle( x, y, x + 15, y + 15 );
end;

procedure TfrmColorIndexSelector.pbPalMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  x_, y_: integer;
begin
  x_ := (X - 8) div 16;
  y_ := (Y - 8) div 16;
  if (x_ < 0) or (x_ > 15) then
    Exit;
  if (y_ < 0) or (y_ > 15) then
    Exit;
  nIndex := y_ * 16 + x_;
  dfIndex.Caption := IntToStr( nIndex );
  Paint;
end;

procedure TfrmColorIndexSelector.FormDblClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

end.
